% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEquation.R
\name{addCovarEquation}
\alias{addCovarEquation}
\title{Add covariates to equation}
\usage{
addCovarEquation(
  equation,
  covar = list(),
  prefix = "f",
  grouplabels = NULL,
  multipleMediator = FALSE
)
}
\arguments{
\item{equation}{The equation}

\item{covar}{A list}

\item{prefix}{prefix}

\item{grouplabels}{A list}

\item{multipleMediator}{logical}
}
\description{
Add covariates to equation
}
\examples{
equation="M ~ X*W\nY ~ a1*M + C1*X"
covar=list(name=c("C1","C2","C3"),label=c("ese","sex","tenure"),site=list(c("M","Y"),"Y","Y"))
grouplabels=list(C1="e")
addCovarEquation(equation,covar=covar)
equation="M1 ~ a11*X\nM2 ~ a12*M"
covar=list(name=c("C1","C2","C3"),label=c("ese","sex","tenure"),site=list(c("M1","Y"),"M2","M2"))
addCovarEquation(equation,covar=covar,multipleMediator=TRUE)
addCovarEquation(equation,covar=covar)
}
