% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_relativities.R
\name{pretty_relativities}
\alias{pretty_relativities}
\title{pretty_relativities}
\usage{
pretty_relativities(
  feature_to_plot,
  model_object,
  plot_approx_ci = TRUE,
  relativity_transform = "exp(estimate)-1",
  ordering = NULL,
  plot_factor_as_numeric = FALSE,
  width = 800,
  height = 500,
  return_data = FALSE,
  ylabel = "Relativity"
)
}
\arguments{
\item{feature_to_plot}{A string of the variable to plot.}

\item{model_object}{Model object to create coefficient table for. Must be of type: \link[stats]{glm}, \link[stats]{lm},  \link[parsnip]{linear_reg} or \link[parsnip]{logistic_reg}}

\item{plot_approx_ci}{Set to TRUE to include confidence intervals in summary table. Warning, can be computationally expensive.}

\item{relativity_transform}{String of the function to be applied to the model estimate to calculate the relativity, for example: 'exp(estimate)'. Default is for relativity to be 'exp(estimate)-1'.}

\item{ordering}{Type III statistical test to perform. Default is none. Options are 'Wald' or 'LR'. Warning 'LR' can be computationally expensive. Test performed via \link[car]{Anova}}

\item{plot_factor_as_numeric}{Set to TRUE to return \link[base]{data.frame} instead of creating \link[knitr]{kable}.}

\item{width}{Width of plot}

\item{height}{Height of plot}

\item{return_data}{Set to TRUE to return data set instead of plot}

\item{ylabel}{Label for yaxis of relativity plot, some users may prefer to refer to this as log odds}
}
\value{
\link[knitr]{kable} if return_data = FALSE. \link[base]{data.frame} if return_data = TRUE.
}
\description{
Creates a pretty html plot of model relativities including base Levels.
}
\examples{
library(dplyr)
library(prettyglm)
data('titanic')
columns_to_factor <- c('Pclass',
                       'Sex',
                       'Cabin',
                       'Embarked',
                       'Cabintype',
                       'Survived')
titanic  <- titanic  \%>\%
  dplyr::mutate_at(columns_to_factor, list(~factor(.)))
survival_model <- stats::glm(Survived ~
                              Pclass +
                              Sex +
                              Age +
                              Fare +
                              Embarked +
                              SibSp +
                              Parch +
                              Cabintype,
                             data = titanic,
                             family = binomial(link = 'logit'))
pretty_relativities(feature_to_plot = 'Pclass',
                    model_object = survival_model)
}
