% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify_Shiny.R
\name{reindent_Shiny}
\alias{reindent_Shiny}
\title{Reindent code using Shiny}
\usage{
reindent_Shiny(contents = NA, language = NA, tabSize = NULL, themeInfo = NULL)
}
\arguments{
\item{contents}{the code to be reindented; there are three possibilities for
this argument:
\code{NA} (default), to use the file currently opened in RStudio;
the path to a file;
or the code given as a character vector}

\item{language}{the language of the code, such as \code{"javascript"};
see \code{\link{getPrettifiableLanguages}};
if the contents are read from a file and \code{language=NA}, then the
language is guessed from the file extension}

\item{tabSize}{number of spaces of the indentation (usually \code{2} or
\code{4});
if \code{NULL} (the default), there are two possibilities:
if the contents are read from the current file in RStudio, then the
number of spaces will be the one you use in RStudio;
otherwise it is set to \code{2}}

\item{themeInfo}{this argument is not important, it controls the theme of
the Shiny app;
it must be \code{NULL} or a list with two fields: \code{editor}, the name
of a theme, and \code{dark}, a logical value, which tells whether the
theme is dark}
}
\value{
The reindented code in a character string.
}
\description{
Reindent some code using a Shiny app.
}
