% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{arg_match0_integer}
\alias{arg_match0_integer}
\title{Match an argument to a integer vector but skip \code{NA}}
\usage{
arg_match0_integer(
  arg,
  values,
  allow_na = TRUE,
  arg_nm = rlang::caller_arg(arg),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{arg}{A symbol referring to an argument accepting strings.}

\item{values}{A character vector of possible values that \code{arg} can take.}

\item{allow_na}{Input boolean to determine if \code{NA} or \code{NaN} is allowed.
Default: \code{TRUE}}

\item{arg_nm}{Same as \code{error_arg}.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
The integer supplied to \code{arg}.
}
\description{
This is equivalent to \code{\link[rlang]{arg_match}} but an
integer vector is compared and skip \code{NA}.
}
