% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the preregr package}
\format{
An object of class \code{list} of length 4.
}
\usage{
opts
}
\description{
The \code{preregr::opts} object contains three functions to set, get, and reset
options used by the preregr package. Use \code{preregr::opts$set} to set options,
\code{preregr::opts$get} to get options, or \code{preregr::opts$reset} to reset specific or
all options to their default values.
}
\details{
It is normally not necessary to get or set \code{preregr} options.

The following arguments can be passed:

\describe{
\item{...}{For \code{preregr::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example, \code{utteranceMarker = "\\n"}. For
\code{preregr::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{preregr::opts$set}, the name of the option to set.}
\item{default}{For \code{preregr::opts$get}, the default value to return if the
option has not been manually specified.}
}

The following options can be set:

\describe{
\item{quridPrefix}{The prefix for quasi-unique record identifiers (QURIDs).}

\item{Two}{Second item}
}
}
\examples{
### Get the default "silence versus chattiness" setting
preregr::opts$get(silent);

### Set it to show all messages
preregr::opts$set(silent = FALSE);

### Check that it worked
preregr::opts$get(silent);

### Reset this option to its default value
preregr::opts$reset(silent);

### Check that the reset worked, too
preregr::opts$get(silent);

}
\keyword{datasets}
