% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_bin_sampling.R
\name{rbbinom}
\alias{rbbinom}
\title{Sampling of beta-binomial data}
\usage{
rbbinom(n, size, prob, rho)
}
\arguments{
\item{n}{defines the number of clusters (\eqn{i})}

\item{size}{integer vector defining the number of trials per cluster (\eqn{n_i})}

\item{prob}{probability of success on each trial (\eqn{\pi})}

\item{rho}{intra class correlation (\eqn{\rho})}
}
\value{
a \code{data.frame} with two columns (succ, fail)
}
\description{
rbbinom samples beta-binomial data according to Menssen and Schaarschmidt (2019).
}
\details{
For beta binomial data with \eqn{i=1, ... I} clusters, the variance is
\deqn{var(y_i)= n_i \pi (1-\pi) (1+ (n_i - 1) \rho)}
with \eqn{\rho} as the intra class correlation coefficient
\deqn{\rho = 1 / (1+a+b).}
For the sampling \eqn{(a+b)} is defined as
\deqn{(a+b)=(1-\rho)/(\rho)}
where \eqn{a=\pi (a+b)} and \eqn{b=(a+b)-a}. Then, the binomial proportions
for each cluster are sampled from the beta distribution
\deqn{\pi_i \sim Beta(a, b)}
and the number of successes for each cluster are sampled to be
\deqn{y_i \sim Bin(n_i, \pi_i).}
In this parametrization \eqn{E(\pi_i)=\pi=a/(a+b)} and \eqn{E(y_i)=n_i \pi}.
Please note, that \eqn{1+ (n_i-1) \rho} is a constant if all cluster sizes are
the same and hence, in this special case, also the quasi binomial assumption is
fulfilled.
}
\examples{
# Sampling of example data
set.seed(234)
bb_dat1 <- rbbinom(n=10, size=50, prob=0.1, rho=0.06)
bb_dat1


set.seed(234)
bb_dat2 <- rbbinom(n=3, size=c(40, 50, 60), prob=0.1, rho=0.06)
bb_dat2


}
\references{
Menssen M, Schaarschmidt F.: Prediction intervals for overdispersed binomial data
with application to historical controls. Statistics in Medicine. 2019;38:2652-2663.
https://doi.org/10.1002/sim.8124
}
