% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quasi_pois_pi.R
\name{quasi_pois_pi}
\alias{quasi_pois_pi}
\title{Prediction intervals for quasi-poisson data}
\usage{
quasi_pois_pi(
  histdat,
  newdat = NULL,
  m = NULL,
  alternative = "both",
  alpha = 0.05,
  nboot = 10000,
  lambda_min = 0.01,
  lambda_max = 10,
  traceplot = TRUE,
  n_bisec = 30
)
}
\arguments{
\item{histdat}{a \code{data.frame} with one column containing the historical data}

\item{newdat}{a \code{data.frame} with one column containing the future data}

\item{m}{number of future clusters}

\item{alternative}{either "both", "upper" or "lower".
\code{alternative} specifies if a prediction interval or
an upper or a lower prediction limit should be computed}

\item{alpha}{defines the level of confidence (1-alpha)}

\item{nboot}{number of bootstraps}

\item{lambda_min}{lower start value for bisection}

\item{lambda_max}{upper start value for bisection}

\item{traceplot}{plot for visualization of the bisection process}

\item{n_bisec}{maximal number of bisection steps}
}
\value{
If \code{newdat} is specified: A \code{data.frame} that contains the future data,
 the historical mean (hist_mean), the calibrated coefficient (quant_calib),
 the prediction error (pred_se), the prediction interval (lower and upper)
 and a statement if the prediction interval covers the future observation (cover).

 If \code{m} is specified: A \code{data.frame} that contains the number of future observations (m)
 the historical mean (hist_mean), the calibrated coefficient (quant_calib),
 the prediction error (pred_se) and the prediction interval (lower and upper).

 If \code{alternative} is set to "lower": Lower prediction bounds are computed instead
 of a prediction interval.

 If \code{alternative} is set to "upper": Upper prediction bounds are computed instead
 of a prediction interval.
}
\description{
quasi_pois_pi calculates bootstrap calibrated prediction intervals for poisson
data with constant overdispersion (quasi-poisson).
}
\details{
This function returns a bootstrap calibrated prediction interval
\deqn{[l,u] = \hat{y} \pm q \sqrt{\hat{var}(\hat{y} - y)}}
with \eqn{\hat{y}} as the predicted future observation,
\eqn{y} as the observed future observations, \eqn{\sqrt{\hat{var}(\hat{y} - y)}}
as the prediction error and \eqn{q} as the bootstrap calibrated coefficient that
approximates a quantile of a multivariate normal distribution. \cr
If traceplot=TRUE, a graphical
overview about the bisection process is given.
}
\examples{
#' # Historical data
qp_dat1

# Future data
qp_dat2

# Prediction interval using bb_dat2 as future data
quasi_pois_pi(histdat=data.frame(qp_dat1), newdat=data.frame(qp_dat2), nboot=100)

# Upper prediction bound for m=3 future observations
quasi_pois_pi(histdat=data.frame(qp_dat1), m=3, alternative="upper", nboot=100)

# Please note that nboot was set to 100 in order to increase computing time
# of the example. For a valid analysis set nboot=10000.

}
