% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.r
\name{cv}
\alias{cv}
\title{Evaluate Trait Predictability via Cross Validation}
\usage{
cv(
  fix = NULL,
  gena,
  gend = NULL,
  y,
  method = "GBLUP",
  nfold = 5,
  nTimes = 1,
  seed = 123,
  CPU = 1
)
}
\arguments{
\item{fix}{a design matrix of the fixed effects.}

\item{gena}{a matrix (n x m) of additive genotypes for the training population.}

\item{gend}{a matrix (n x m) of domiance genotypes for the training population. Default is NULL.}

\item{y}{a vector(n x 1) of the phenotypic values.}

\item{method}{eight GS methods including "GBLUP", "BayesB", "RKHS", "PLS", "LASSO", "EN", "XGBOOST", "RF".
Users may select one of these methods or all of them simultaneously with "ALL". Default is "GBLUP".}

\item{nfold}{the number of folds. Default is 5.}

\item{nTimes}{the number of independent replicates for the cross-validation. Default is 1.}

\item{seed}{the random number. Default is 123.}

\item{CPU}{the number of CPU.}
}
\value{
Trait predictability
}
\description{
The cv function evaluates trait predictability based on eight GS methods via k-fold cross validation.
The trait predictability is defined as the squared Pearson correlation coefficient between the observed and the predicted trait values.
}
\examples{
\donttest{
## load example data from hypred package
data(hybrid_phe)
data(input_geno)

## convert original genotype
inbred_gen <- convertgen(input_geno, type = "hmp2")

##additive model infer the additive and dominance genotypes of hybrids
gena <- infergen(inbred_gen, hybrid_phe)$add
gend <- infergen(inbred_gen, hybrid_phe)$dom

##additive model
R2<-cv(fix=NULL,gena,gend=NULL,y=hybrid_phe[,3],method ="GBLUP",nfold=5,nTimes=1,seed=123,CPU=1)

##additive-dominance model
R2<-cv(fix=NULL,gena,gend,y=hybrid_phe[,3],method ="GBLUP",nfold=5,nTimes=1,seed=123,CPU=1)}
}
