% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossv.R
\name{boxplot.precmed}
\alias{boxplot.precmed}
\title{A set of box plots of estimated ATEs from the \code{"precmed"} object}
\usage{
\method{boxplot}{precmed}(
  x,
  ylab = NULL,
  plot.hr = FALSE,
  title = waiver(),
  theme = theme_classic(),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"precmed"}.}

\item{ylab}{A character value for the y-axis label to describe what the ATE is. Default is \code{NULL},
which creates a default y-axis label based on available data.}

\item{plot.hr}{A logical value indicating whether the hazard ratios should be plotted in the
validation curves (\code{TRUE}). Otherwise, the restricted mean time lost is plotted (\code{FALSE}).
This argument is only applicable to survival outcomes. Default is \code{FALSE}.}

\item{title}{The text for the title}

\item{theme}{Defaults to \code{theme_classic()}. Other options include \code{theme_grey()}, \code{theme_bw()}, \code{theme_light()}, \code{theme_dark()}, and \code{theme_void()}}

\item{...}{Other parameters}
}
\value{
Returns sets of box plots, one set for each scoring method, over each of the multi-category
subgroups. A gray horizontal dashed line of the overall ATE is included as a reference.
}
\description{
Provides box plots which depict distributions of estimated ATEs for each multi-category subgroup in
the validation set across all cross-validation iterations. The subgroups are mutually exclusive and
are categorized by the CATE score percentiles (\code{prop.multi} specified in \code{\link{catecv}()} or
\code{\link{catecvmean}()}). Box plots of mutually exclusive subgroups are constructed separately by scoring
method specified in \code{\link{catecv}()}. This should be run only after results of \code{\link{catecv}()} or
\code{\link{catecvmean}()}) have been obtained.
}
\details{
\code{\link{boxplot}()} takes in outputs from \code{\link{catecv}()} and generates
the box plots of estimated ATEs for multi-category subgroups of the validation set.
The box plots together with the overall ATE reference line can help compare the scoring methods'
ability to distinguish subgroups of patients with different treatment effects.

For a given scoring method, box plots showing increasing or decreasing trends across the
multi-category subgroups indicate presence of treatment effect heterogeneity
(and the ability of the scoring method to capture it). On the contrary, box plots which
are relatively aligned across the multi-category subgroups indicate absence of treatment
effect heterogeneity (or the inability of the scoring method to capture it).
}
\examples{
\donttest{
# Count outcome
eval_1 <- catecv(response = "count",
                 data = countExample,
                 score.method = "poisson",
                 cate.model = y ~ age + female + previous_treatment +
                                  previous_cost + previous_number_relapses +
                                  offset(log(years)),
                 ps.model = trt ~ age + previous_treatment,
                 higher.y = FALSE,
                 cv.n = 5)

boxplot(eval_1, ylab = "Rate ratio of drug1 vs drug0 in each subgroup")

# Survival outcome
library(survival)
tau0 <- with(survivalExample,
             min(quantile(y[trt == "drug1"], 0.95), quantile(y[trt == "drug0"], 0.95)))
eval_2 <- catecv(response = "survival",
                 data = survivalExample,
                 score.method = c("poisson", "randomForest"),
                 cate.model = Surv(y, d) ~ age + female + previous_cost +
                                           previous_number_relapses,
                 ps.model = trt ~ age + previous_treatment,
                 initial.predictor.method = "randomForest",
                 ipcw.model = ~ age + previous_cost + previous_treatment,
                 tau0 = tau0,
                 higher.y = TRUE,
                 cv.n = 5,
                 seed = 999)

boxplot(eval_2, ylab = "RMTL ratio of drug1 vs drug0 in each subgroup")
}

}
\references{
Yadlowsky, S., Pellegrini, F., Lionetto, F., Braune, S., & Tian, L. (2020).
\emph{Estimation and validation of ratio-based conditional average treatment effects using
observational data. Journal of the American Statistical Association, 1-18.}
\url{https://www.tandfonline.com/doi/full/10.1080/01621459.2020.1772080}
}
\seealso{
\code{\link{plot}} and \code{\link{abc}()} for \code{"precmed"} objects.
}
