% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rai.r
\name{rai}
\alias{precintcon.rai.analysis}
\alias{rai}
\title{Rainfall Anomaly Index}
\usage{
rai(object, granularity = "m")
}
\arguments{
\item{object}{a daily or monthly precipitation serie.}

\item{granularity}{the granularity applied for calculating the rainfall anomaly index,
which should be either "m" for monthly granularity or "a" for annual granularity. (Default value: "m")}
}
\value{
A data.frame (precintcon.rai) containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{month} is the month. This attribute exists only when granularity = "m".
\item \code{rai} is the rainfall anomaly index.
}
}
\description{
Calculates the Rainfall Anomaly Index (RAI) on a daily or
monthly precipitation serie.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

##
# Performing the Rainfall Anomaly Index analysis
rai(monthly, granularity = "m")
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{pplot.rai}}
\code{\link{read.data}}
}
\keyword{anomaly}
\keyword{index}
\keyword{precipitation}
\keyword{rainfall}

