% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{pre}
\alias{pre}
\title{Derive a prediction rule ensemble}
\usage{
pre(formula, data, family = c("gaussian", "binomial", "poisson"),
  use.grad = TRUE, weights, type = "both", sampfrac = 0.5,
  maxdepth = 3L, learnrate = 0.01, mtry = Inf, ntrees = 500,
  removecomplements = TRUE, removeduplicates = TRUE, winsfrac = 0.025,
  normalize = TRUE, standardize = FALSE, nfolds = 10L, verbose = FALSE,
  par.init = FALSE, par.final = FALSE, tree.control, ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit of the form 
\code{y ~ x1 + x2 + ...+ xn}. Response (left-hand side of the formula) 
should be of class numeric or of class factor (with two levels). If the 
response is a factor, an ensemble for binary classification is created.
Otherwise, an ensemble for prediction of a numeric response is created. If
the outcome is a non-negative count, this should additionally be specified 
by setting\code{family = "poisson"}. Note that input variables may not have 
'rule' as (part of) their name, and the formula may not exclude the intercept 
(that is, \code{+ 0} or \code{- 1} may not be used in the right-hand side of 
the formula).}

\item{data}{data.frame containing the variables in the model. Response must
be a factor for binary classification, numeric for (count) regression. Input
variables must be of class numeric, factor or ordered factor.}

\item{family}{character. Specification is required only for non-negative 
count responses, by specifying \code{family = "poisson"}. Otherwise, 
\code{family = "gaussian"} is employed if response specified in formula
is numeric and \code{family = "binomial"} is employed if response is a 
binary factor. Note that if \code{family = "poisson"} is specified, 
\code{\link[partykit]{glmtree}} with an intercept only models in the nodes 
will be employed for inducing trees, instead of \code{\link[partykit]{ctree}}. 
Although this yields longer computation times, it also yields better 
accuracy for count outcomes.}

\item{use.grad}{logical. Should binary outcomes use gradient boosting with 
regression trees when \code{learnrate > 0}? That is, use 
\code{\link[partykit]{ctree}} as in Friedman (2001) with a second order 
Taylor expansion? By default set to \code{TRUE}, as this yields shorter
computation time. If set to \code{FALSE}, \code{\link[partykit]{glmtree}}
with intercept only models in the nodes will be employed. This will yield
longer computation times (but may increase the likelihood of detecting
interactions).}

\item{weights}{an optional vector of observation weights to be used for 
deriving the ensemble.}

\item{type}{character. Specifies type of base learners to be included in the 
ensemble. Defaults to \code{"both"} (initial ensemble will include both rules 
and linear functions). Other option are \code{"rules"} (prediction 
rules only) or \code{"linear"} (linear functions only).}

\item{sampfrac}{numeric. Takes values \eqn{> 0} and \eqn{\leq 1}, representing 
the fraction of randomly selected training observations used to produce each 
tree. Values \eqn{< 1} will result in sampling without replacement (i.e., 
subsampling), a value of 1 will result in sampling with replacement 
(i.e., bootstrapping).}

\item{maxdepth}{numeric. Maximum number of conditions that can define a rule.}

\item{learnrate}{numeric. Learning rate or boosting parameter.}

\item{mtry}{numeric. Number of randomly selected predictor variables for 
creating each split in each tree.}

\item{ntrees}{numeric. Number of trees to generate for the initial ensemble.}

\item{removecomplements}{logical. Remove rules from the ensemble which have
the same support in the training data as the inverse of other rules?}

\item{removeduplicates}{logical. Remove rules from the ensemble which have 
the exact same support in training data?}

\item{winsfrac}{numeric. Quantiles of data distribution to be used for 
winsorizing linear terms. If set to 0, no winsorizing is performed. Note 
that ordinal variables are included as linear terms in estimating the
regression model and will also be winsorized.}

\item{normalize}{logical. Normalize linear variables before estimating the 
regression model? Normalizing gives linear terms the same a priori influence 
as a typical rule, by dividing the (winsorized) linear term by 2.5 times its 
SD.}

\item{standardize}{logical. Should rules and linear terms be standardized to
have SD equal to 1 before estimating the regression model? This will also 
standardize the dummified factors, users are advised to use the default 
\code{standardize = FALSE}.}

\item{nfolds}{numeric. Number of cross-validation folds to be used for 
selecting the optimal value of the penalty parameter \eqn{\lambda} in selecting
the final ensemble.}

\item{verbose}{logical. Should information on the initial and final ensemble 
be printed to the command line?}

\item{par.init}{logical. Should parallel foreach be used to generate initial 
ensemble? Only used when \verb{learnrate == 0} and \code{family != "poisson"}. 
Must register parallel beforehand, such as doMC or others.}

\item{par.final}{logical. Should parallel foreach be used to perform cross 
validation for selecting the final ensemble? Must register parallel beforehand, 
such as doMC or others.}

\item{tree.control}{list with control parameters to be passed to the tree 
fitting function, see \code{\link[partykit]{ctree_control}}.}

\item{...}{Additional arguments to be passed to 
\code{\link[glmnet]{cv.glmnet}}.}
}
\value{
an object of class \code{pre}, which contains the initial ensemble of 
rules and/or linear terms and the final ensembles for a wide range of penalty
parameter values. By default, the final ensemble employed by all of the other
methods and functions in package \code{pre} is selected using the 'minimum
cross validated error plus 1 standard error' criterion. All functions and 
methods also take a \code{penalty.parameter.value} argument, which can be
used to select a more or less sparse final ensembles. The 
\code{penalty.parameter.value} argument takes values \code{"lambda.1se"} 
(the default), \code{"lambda.min"}, or a numeric value. Users can assess 
the trade of between sparsity and accuracy provided by every possible value 
of the penalty parameter (\eqn{\lambda}) by running \code{object$glmnet.fit} 
and \code{plot(object$glmnet.fit)}.
}
\description{
\code{pre} derives a sparse ensemble of rules and/or linear functions for 
prediction of a continuous or binary outcome.
}
\details{
Obervations with missing values will be removed prior to analysis.

In rare cases, duplicated variable names may appear in the model.
For example, the first variable is a factor named 'V1' and there are also
non-factor variables called 'V10' and/or 'V11' and/or 'V12' (etc). Then for 
the binary factor V1, dummy contrast variables will be created, called 
'V10', 'V11', 'V12' (etc). As should be clear from this example, this yields 
duplicated variable names, which will yield warnings, errors and incorrect 
results. Users should prevent this by renaming variables prior to analysis.

Inputs can be numeric, ordered or factor variables. Reponse can be
a numeric, count or binary categorical variable.
}
\note{
The code for deriving rules from the nodes of trees was taken from an 
internal function of the \code{partykit} package of Achim Zeileis and Torsten 
Hothorn.
}
\examples{
\donttest{
set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),], verbose = TRUE)}
}
\references{
Friedman, J. H. (2001). Greedy function approximation: a gradient boosting machine. \emph{The Annals of Applied Statistics, 29}(5), 1189-1232.
}
\seealso{
\code{\link{print.pre}}, \code{\link{plot.pre}}, 
\code{\link{coef.pre}}, \code{\link{importance}}, \code{\link{predict.pre}}, 
\code{\link{interact}}, \code{\link{cvpre}}
}
