% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{importance}
\alias{importance}
\title{Calculate importances of base learners (rules and linear terms) and input 
variables}
\usage{
importance(object, plot = TRUE, ylab = "Importance",
  main = "Variable importances", global = TRUE, quantprobs = c(0.75, 1),
  col = "grey", round = NA, ...)
}
\arguments{
\item{object}{an object of class \code{\link{pre}}}

\item{plot}{logical. Should variable importances be plotted?}

\item{ylab}{character string. Plotting label for y-axis. Only used when 
\code{plot = TRUE}.}

\item{main}{character string. Main title of the plot. Only used when 
\code{plot = TRUE}.}

\item{global}{logical. Should global importances be calculated? If FALSE, 
local importances are calculated, given the quantiles of the predictions F(x) 
in \code{quantprobs}.}

\item{quantprobs}{optional numeric vector of length two. Only used when 
\code{global = FALSE} (in which case specification of this argument is still 
optional). Probabilities for calculating sample quantiles of the range of F(X), 
over which local importances are calculated. The default provides variable 
importances calculated over the 25\% highest values of F(X).}

\item{col}{character string. Plotting color to be used for bars in barplot.}

\item{round}{integer. Number of decimal places to round numeric results to.
If NA (default), no rounding is performed.}

\item{...}{further arguments to be passed to \code{barplot} (only used 
when \code{plot = TRUE}).}
}
\value{
A list with two dataframes: $baseimps, giving the importances for 
baselearners in the ensemble, and $varimps, giving the importances for 
variables that appear and do not appear in the ensemble.
}
\description{
\code{importance} calculates importances for rules, linear terms and input 
variables in the ensemble, and provides a bar plot of variable importances.
}
\examples{
\donttest{
airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
# calculate global importances:
importance(airq.ens) 
# calculate local importances (default: over 25\% highest predicted values):
importance(airq.ens, global = FALSE) 
# calculate local importances (custom: over 25\% highest predicted values):
importance(airq.ens, global = FALSE, quantprobs = c(0, .25))}
}

