% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_interface.R
\name{create_toolset}
\alias{create_toolset}
\title{Create a set of tools}
\usage{
create_toolset(tool_names = NULL, set_names = NULL, calc_auc = TRUE,
  store_res = TRUE)
}
\arguments{
\item{tool_names}{A character vector to specify the names of
  performance evaluation tools. The names for the following five tools can be
  currently used.

  \itemize{
    \item ROCR
    \item AUCCalculator
    \item PerfMeas
    \item PRROC
    \item precrec
  }}

\item{set_names}{A character vector to specify a predefined set name.
  Following six sets are currently available.

  \describe{
    \item{"def5"}{A set of 5 tools with \code{calc_auc = TRUE} and \code{store_res = TRUE}}
    \item{"auc5"}{A set of 5 tools with \code{calc_auc = TRUE} and \code{store_res = FALSE}}
    \item{"crv5"}{A set of 5 tools with \code{calc_auc = FALSE} and \code{store_res = TRUE}}
    \item{"def4"}{A set of 4 tools with \code{calc_auc = TRUE} and \code{store_res = TRUE}}
    \item{"auc4"}{A set of 4 tools with \code{calc_auc = TRUE} and \code{store_res = FALSE}}
    \item{"crv4"}{A set of 4 tools with \code{calc_auc = FALSE} and \code{store_res = TRUE}}
  }}

\item{calc_auc}{A Boolean value to specify whether the AUC score should be
calculated.}

\item{store_res}{A Boolean value to specify whether the calculated curve is
retrieved and stored}
}
\value{
A list of \code{R6} tool objects.
}
\description{
The \code{create_toolset} function takes names of predefined tools and
  generates a list of wrapper functions for Precision-Recall curve
  calculations.
}
\examples{
## Create ROCR and precrec
toolset1 <- create_toolset(c("ROCR", "precrec"))

## Create auc5 tools
toolset2 <- create_toolset(set_names = "auc5")

}
\seealso{
\code{\link{run_benchmark}} and \code{\link{run_evalcurve}} require
 the list of the tools generated by this function
 \code{\link{ToolROCR}}, \code{\link{ToolAUCCalculator}},
 \code{\link{ToolPerfMeas}}, \code{\link{ToolPRROC}}, and
 \code{\link{Toolprecrec}} as R6 tool classes.
}

