% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{kernelIntensities}
\alias{kernelIntensities}
\title{Direct kernel estimator intensities}
\usage{
kernelIntensities(data, tau, Q, n, directed, rho = 1, sparse = FALSE,
  nb.points = 1000)
}
\arguments{
\item{data}{List with 3 components:
\itemize{
  \item data$time.seq : sequence of observed time points of the m-th event (M-vector)
  \item data$type.seq : sequence of observed values convertNodePair(i,j,n,directed) (auxiliary.R)
      of process that produced the mth event (M-vector)
  \item $Time - [0,data$Time] is the total time interval of observation
}}

\item{tau}{\eqn{\tau}}

\item{Q}{Total number of groups}

\item{n}{Total number of nodes}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}

\item{rho}{\eqn{\rho}}

\item{sparse}{Boolean for sparse (TRUE) or not sparse (FALSE) case}

\item{nb.points}{Number of points}
}
\description{
Compute smooth intensities with direct kernel estimation of intensities relying on a classification tau.
This can be used with the values \eqn{\tau} obtained on a dataset with mainVEM function run with 'hist' method.
}
\details{
Warning : sparse case not implemented !!!
}
\examples{

# The generated_sol_kernel was generated calling mainVEM with kernel method on the generated_Q3 data
# (50 individuals and 3 clusters)

data <- generated_Q3$data

n <- 50
Q <- 3


# compute smooth intensity estimators
sol.kernel.intensities <- kernelIntensities(data,generated_sol_kernel$tau,Q,n,directed=FALSE)

}
