% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiMWI2020}
\alias{ppiMWI2020}
\title{Poverty Probability Index (PPI) lookup table for Malawi}
\format{
A data frame with 16 columns and 100 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{extreme}}{Extreme poverty line}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{ppp100}}{Below $1.00 per day purchasing power parity (2011)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp320}}{Below $3.20 per day purchasing power parity (2011)}
\item{\code{ppp550}}{Below $5.50 per day purchasing power parity (2011)}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
\item{\code{percentile20}}{Below 20th percentile poverty line}
\item{\code{percentile40}}{Below 40th percentile poverty line}
\item{\code{percentile60}}{Below 50th percentile poverty line}
\item{\code{percentile80}}{Below 60th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiMWI2020
}
\description{
Poverty Probability Index (PPI) lookup table for Malawi
}
\examples{
  # Access Malawi PPI table
  ppiMWI2020

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiMWI2020[ppiMWI2020$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiMWI2020, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiMWI2020[ppiMWI2020$score == ppiScore, "extreme"]

}
\keyword{datasets}
