% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova2way.c.bal.R
\name{anova2way.c.bal}
\alias{anova2way.c.bal}
\title{Power calculation for two-way balanced analysis of variance contrast test}
\usage{
anova2way.c.bal(
  n = NULL,
  mmatrix = NULL,
  cvec = NULL,
  factor = c("a", "b"),
  sd = 1,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{n}{The sample size per cell}

\item{mmatrix}{A matrix of cell means (see example).}

\item{cvec}{A vector of contrast coefficients c(c1, c2, ...).}

\item{factor}{Either "a" for rows or "b" for columns depending on which factor the contrast test is being made on.}

\item{sd}{The estimated standard deviation within each cell; defaults to 1.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs sample size and power calculations for a test of a contrast
between levels of a factor in a two-way
ANOVA with balanced data (that is, equal sized cells). Can be used to solve for
power, n (sample size per cell), or alpha. For unbalanced data, see
anova2way.c.unbal. For a test of a contrast among cell means, see
anova2way.se.bal.
}
\examples{
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.3), nrow = 2, byrow = TRUE)
anova2way.c.bal(n = 30, mmatrix = mmatrix, cvec = c(1, 0, -1), factor = "b",
sd = 2, alpha = 0.05)
}
