#' @title
#' Update package logo
#'
#' @description
#' This function is meant for generating or updating the logo. After running
#' this procedure we end up with what is stored in the `LOGO` constant.
#'
#' @param ascii_logo_path A character string representing the path to the logo
#' template.
#'
#' @param version A numerical vector of three positive integers representing the
#' version of the package to append to the logo.
#'
#' @return The ASCII logo.
#'
#' @keywords internal
make_logo <- function(ascii_logo_path = "./inst/assets/logo/logo.txt", version = c(1, 0, 0)) {
    # Load the ASCII logo.
    logo <- readLines(ascii_logo_path)
    logo <- dput(logo)

    # Update versioning.
    logo <- gsub("{{major}}", version[1], logo, perl = TRUE)
    logo <- gsub("{{minor}}", version[2], logo, perl = TRUE)
    logo <- gsub("{{patch}}", version[3], logo, perl = TRUE)

    # Print the logo.
    cat(logo, sep = "\n")

    # Condensed version.
    logo <- paste(logo, collapse = "\n")

    return(logo)
}


#' @title
#' The `powerly` package logo
#'
#' @description
#' The logo is generated by [make_logo()] and displayed at package load time.
#'
#' @keywords internal
LOGO = ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n.                                            _     v1.x.x .\n.                                           | |           .\n.   _ __     ___   __      __   ___   _ __  | |  _   _    .\n.  | '_ \\   / _ \\  \\ \\ /\\ / /  / _ \\ | '__| | | | | | |   .\n.  | |_) | | (_) |  \\ V  V /  |  __/ | |    | | | |_| |   .\n.  | .__/   \\___/    \\_/\\_/    \\___| |_|    |_|  \\__, |   .\n.  | |                                            __/ |   .\n.  |_|                                           |___/    .\n.                                                         .\n. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n.                            .                            .\n. Author: Mihai A. Constantin                             .\n. Contact: mihai@mihaiconstantin.com                      .\n. Source: github.com/mihaiconstantin/powerly              .\n.                            .                            .\n. . . . . . . . . . . . . . . . . . . . . . . . . . . . . ."
