% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpl.R, R/ppl.R, R/qpl.R, R/rpl.R
\name{pl}
\alias{pl}
\alias{dpl}
\alias{pl}
\alias{ppl}
\alias{pl}
\alias{qpl}
\alias{pl}
\alias{rpl}
\title{The Power Logistic Distribution}
\usage{
dpl(x, lambda, mu = 0, sigma = 1)

ppl(q, lambda, mu = 0, sigma = 1)

qpl(p, lambda, mu = 0, sigma = 1)

rpl(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power logistic distribution with parameters mu, sigma and lambda.
}
\examples{
dpl(1, 1, 3, 4)
ppl(1, 1, 3, 4)
qpl(0.2, 1, 3, 4)
rpl(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 16. Wiley, New York.

Nadarajah, S. (2009) The skew logistic distribution. \emph{AStA Advances in Statistical Analysis}, \strong{93}, 187-203.

Prentice, R. L. (1976) A Generalization of the probit and logit methods for dose-response curves. \emph{Biometrika}, \strong{32}, 761-768.
}
