% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpgmav.R, R/ppgmav.R, R/qpgmav.R, R/rpgmav.R
\name{pgmav}
\alias{pgmav}
\alias{dpgmav}
\alias{pgmav}
\alias{ppgmav}
\alias{pgmav}
\alias{qpgmav}
\alias{pgmav}
\alias{rpgmav}
\title{The Power Gumbel of Maximum Value Distribution}
\usage{
dpgmav(x, lambda, mu = 0, sigma = 1)

ppgmav(q, lambda, mu = 0, sigma = 1)

qpgmav(p, lambda, mu = 0, sigma = 1)

rpgmav(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power Gumbel of maximum value distribution with parameters mu, sigma and lambda.
}
\examples{
dpgmav(1, 1, 3, 4)
ppgmav(1, 1, 3, 4)
qpgmav(0.2, 1, 3, 4)
rpgmav(5, 2, 3, 4)
}
\references{
Abanto -Valle, C. A., Bazán, J. L. and Smith, A. C. (2014) \emph{State space mixed models for binary responses with skewed inverse links using JAGS}. Rio de Janeiro, Brazil.

Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.
}
