% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params.R
\name{get_params}
\alias{get_params}
\title{Obtain the names of all nodes}
\usage{
get_params(post, type = "base_only")
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{type}{Format of returned matches; only two options are accepted:
\itemize{
\item \code{type = "base_only"} (the default) to return only the unique node names (without indices).
\item \code{type = "base_index"} to return the node names with indices included.
}}
}
\value{
A character vector with all node names stored in the \code{post} object, formatted as requested by \code{type}.
}
\description{
Returns the names of all quantities stored in
a \code{\link[coda:mcmc.list]{mcmc.list}} object.
}
\examples{
 # load example mcmc.list
data(cjs)

# get only node names, no indices (default)
get_params(cjs, type = "base_only")

# get indices too, where applicable
get_params(cjs, type = "base_index")
}
