% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_dispatch.R
\name{nn_helper}
\alias{nn_helper}
\title{Helper function for neural networks fitted by neuralnet}
\usage{
nn_helper(X, Y, W, neural.net.Y = NULL, neural.net.W = NULL,
  standardize = TRUE, standardization.method = "min-max")
}
\arguments{
\item{X}{A matrix of covariates (must be all numeric)}

\item{Y}{A vector of the target variable, of same length as the number of rows of Y, must be numeric}

\item{W}{A vector of the treatment variable, of same length as the number of rows of X, must be numeric}

\item{neural.net.Y}{A model specification for Y, see \link[neuralnet]{neuralnet}}

\item{neural.net.W}{A model specification for W, see \link[neuralnet]{neuralnet}}

\item{standardize}{Whether to standardize the data before starting the computation, defaults to TRUE.}

\item{standardization.method}{How to standardize data, defaults to min-max, also offers "Z-transform", "Unit-Scale" and "Mean-Scale"}
}
\value{
A list with two elements: The fitted W model and the fitted Y model.
}
\description{
Helper function that dispatches to neuralnet for the double ML estimation (see details).
}
\details{
For a more steamlined usage, default arguments as implemented in the neuralnet package
are passed to both networks during fitting, unless specified otherwise. Also, any attempt to set
the formula or data arguments of neuralnet will be ignored and rewritted with internal structures.
The function will print a warning if this happens.
}
\examples{
\donttest{
  n = 2000; p = 3
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = rbinom(n, 1, 0.2 + 0.2 * (X[,2] > 0) + W * 0.1)

# note that this neural network can fail to converge

 nn_helper( X,
            Y,
            W,
            neural.net.W = list( act.fct = "logistic" ),
            neural.net.Y = list( act.fc = "logistic" ))
}


}
