% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPmat.R
\name{QPmat}
\alias{QPmat}
\title{Build a projection matrix from a time series of individuals (or densities) per stage}
\usage{
QPmat(nout, C, b, nonzero)
}
\arguments{
\item{nout}{A time series of population vectors}

\item{C}{constraint matrix}

\item{b}{b vector}

\item{nonzero}{indices of the non-zero elements of the transition matrix (counting by column)}
}
\value{
A projection matrix.
}
\description{
Builds one projection matrix from a time series of number (or densities) of
individuals per stage (size classes or life stages) using Wood's quadratic
programming method. The matrix model also requires a constraint matrix C,
vector b, and vector listing nonzero elements of desired projection matrix.
}
\details{
converted Matlab code from Example 6.3 in Caswell (2001)
}
\note{
This function requires \code{solve.QP} in the \code{quadprog} package.
}
\examples{
\dontrun{
## list nonzero elements
nonzero <- c( 1, 2, 5, 6, 7, 9)
## create C matrix
C <- rbind(diag(-1,6), c(1,1,0,0,0,0), c(0,0,1,1,0,0), c(0,0,0,0,0,1))
## calculate b (transpose is not necessary - either way works)
b <- apply(C, 1, max)
QPmat(nematode, C,b,nonzero)
}

}
\author{
Adapted to R by Patrick Nantel
}
