% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_rates_utils.R
\name{rate_ratio}
\alias{rate_ratio}
\title{Confidence intervals for the rate ratios}
\usage{
rate_ratio(x, y, crude = FALSE, SE.method = TRUE)
}
\arguments{
\item{x}{a rate-object, vector of two; rate and standard error or observed and person-years.}

\item{y}{a rate-object, vector of two; rate and standard error or observed and person-years.}

\item{crude}{set TRUE to use crude rates; default is FALSE.}

\item{SE.method}{default TRUE; if \code{x} and \code{y} are vectors of observed and 
person-years, this must be changed to FALSE.}
}
\value{
A vector length of three: rate_ratio, and lower and upper confidence intervals.
}
\description{
Calculate rate ratio with confidence intervals for rate objects or observations and person-years.
}
\details{
Calculate rate ratio of two age standardized rate objects (see \code{\link{rate}}). 
Multiple rates for each objects is supported if there are an equal number of rates. 
Another option is to set \code{x} and \code{y} as a vector of two.
\enumerate{
  \item rate and its standard error, and  set \code{SE.method = TRUE}.
  \item observations and person-year, and  set \code{SE.method = FALSE}.
}
See examples.
}
\examples{
\dontrun{
# two rate ratios; silly example with female rectal / breast cancer 
## mortality rates
data("sire", package = "popEpi")
data("sibr", package = "popEpi")

BL <- list(per = 2000:2005)

re <- lexpand(sire, birth = "bi_date", entry = "dg_date", exit = "ex_date",
              status = status == 1, breaks = BL, aggre = list(per))
br <- lexpand(sibr, birth = "bi_date", entry = "dg_date", exit = "ex_date",
              status = status == 1, breaks = BL, aggre = list(per))

r_re <- rate(re, obs = "from0to1", pyrs = "pyrs")
r_br <- rate(br, obs = "from0to1", pyrs = "pyrs")

rate_ratio(r_re, r_br, SE.method = TRUE)
}

# manually set rates (0.003 and 0.005) and SEs (0.001 and 0.002)
# so that x = y = c('rate', 'SE')
rate_ratio(x= c(0.003, 0.001), y= c(0.005, 0.002), SE.method = TRUE) 

# observed numbers (10 and 20) and person-years (30000 and 40000):
rate_ratio(x = c(10, 30000), y = c(20, 40000), SE.method = FALSE)

}
\seealso{
\code{\link{rate}}

Other rate functions: \code{\link{rate}}
}
\author{
Matti Rantanen
}
\concept{rate functions}
