% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Surv.R
\name{Surv}
\alias{Surv}
\title{Survival Objects}
\usage{
Surv(
  time,
  time2,
  event,
  type = c("right", "left", "interval", "counting", "interval2", "mstate"),
  origin = 0
)
}
\arguments{
\item{time}{see  \link[survival:Surv]{survival::Surv}}

\item{time2}{see  \link[survival:Surv]{survival::Surv}}

\item{event}{see  \link[survival:Surv]{survival::Surv}}

\item{type}{see  \link[survival:Surv]{survival::Surv}}

\item{origin}{see \link[survival:Surv]{survival::Surv}}
}
\value{
See \verb{[survival::Surv]}.
}
\description{
Wrapper for \link[survival:Surv]{survival::Surv}.
}
\section{Surv in survival vs. in popEpi}{

\code{popEpi::Surv} is a wrapper for \link[survival:Surv]{survival::Surv}.
Therefore you don't need to to do \code{library("survival")} when using \code{Surv}
with e.g.
\code{\link{survtab}}. Remember that if you do \code{library("survival")} after
\code{library("popEpi")}, the \code{Surv} from \pkg{survival} is used instead of
from \pkg{popEpi} (\code{R} throws a warning about this) when an expression
such as \code{Surv(my_times, my_events)} is evaluated. You can avoid such
conflicts by writing e.g. \code{popEpi::Surv(my_times, my_events)} instead.
However, \code{popEpi::Surv} is designed in such a way that this should not
become a problem and you should be able to use the two interchangeably.
}

\seealso{
Other main functions: 
\code{\link{rate}()},
\code{\link{relpois}()},
\code{\link{relpois_ag}()},
\code{\link{sir}()},
\code{\link{sirspline}()},
\code{\link{survmean}()},
\code{\link{survtab}()},
\code{\link{survtab_ag}()}

Other survtab functions: 
\code{\link{lines.survtab}()},
\code{\link{plot.survtab}()},
\code{\link{print.survtab}()},
\code{\link{summary.survtab}()},
\code{\link{survtab}()},
\code{\link{survtab_ag}()}

Other survmean functions: 
\code{\link{lines.survmean}()},
\code{\link{plot.survmean}()},
\code{\link{survmean}()}
}
\concept{main functions}
\concept{survmean functions}
\concept{survtab functions}
