% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfa_xerrors.R
\name{dfa_xerrors}
\alias{dfa_xerrors}
\title{Discriminant Function Approach for Estimating Odds Ratio with Normal Exposure
Subject to Measurement Error}
\usage{
dfa_xerrors(y, xtilde, c = NULL, merror = TRUE, ...)
}
\arguments{
\item{y}{Numeric vector of \code{Y} values.}

\item{xtilde}{List of numeric vectors with \code{Xtilde} values.}

\item{c}{Numeric matrix with \strong{\code{C}} values (if any), with
one row for each pool. Can be a vector if there is only 1 covariate.}

\item{merror}{Logical value for whether there is measurement error.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
 \item Numeric vector with point estimates for \code{gamma_y}, \code{sigsq},
 and the covariate-adjusted log-odds ratio, and the estimated variance for
 the log-odds ratio estimate if \code{estimate_var = TRUE}.
 \item Object returned by \code{\link[stats]{nlminb}} containing information
 about likelihood maximization.
 \item Akaike information criterion (AIC).
}
}
\description{
Assumes exposure measurements are subject to additive normal measurement
error, and exposure given covariates and outcome is a normal-errors linear
regression. Some replicates are required for identifiability.
}
\examples{
# Load datasets - dat1 has (Y, C) values and dat1_xtilde is list with 1 or 2
# Xtilde measurements for each subject. Xtilde values are affected by
# measurement error.
data(dat1)
data(dat1_xtilde)

# Estimate log-OR for X and Y adjusted for C, ignoring measurement error
fit1 <- dfa_xerrors(y = dat1$y, xtilde = dat1_xtilde, c = dat1$c, merror = FALSE)
fit1$estimates

# Repeat, but accounting for measurement error. Closer to true log-OR of 0.5.
fit2 <- dfa_xerrors(y = dat1$y, xtilde = dat1_xtilde, c = dat1$c, merror = TRUE)
fit2$estimates


}
\references{
Lyles, R.H., Van Domelen, D.R., Mitchell, E.M. and Schisterman, E.F. (2015)
"A discriminant function approach to adjust for processing and measurement
error When a biomarker is assayed in pooled samples."
\emph{Int. J. Environ. Res. Public Health} \strong{12}(11): 14723--14740.
}
