% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool-methods.R
\docType{class}
\name{Pool-class}
\alias{Pool-class}
\alias{Pool}
\alias{poolCreate}
\alias{poolClose}
\alias{poolClose,Pool-method}
\title{Create a pool of reusable objects}
\usage{
poolCreate(
  factory,
  minSize = 1,
  maxSize = Inf,
  idleTimeout = 60,
  validationInterval = 60,
  state = NULL
)

poolClose(pool)

\S4method{poolClose}{Pool}(pool)
}
\arguments{
\item{factory}{A zero-argument function called to create the objects that
the pool will hold (e.g. for DBI database connections, \code{\link[=dbPool]{dbPool()}} uses
a wrapper around \code{DBI::dbConnect()}).}

\item{minSize, maxSize}{The minimum and maximum number of objects in the pool.}

\item{idleTimeout}{Number of seconds to wait before destroying idle objects
(i.e. objects available for checkout over and above \code{minSize}).}

\item{validationInterval}{Number of seconds to wait between validating
objects that are available for checkout. These objects are validated
in the background to keep them alive.

To force objects to be validated on every checkout, set
\code{validationInterval = 0}.}

\item{state}{A \code{pool} public variable to be used by backend authors.}

\item{pool}{A Pool object previously created with \code{poolCreate}}
}
\description{
A generic pool class that holds objects. These can be fetched
from the pool and released back to it at will, with very
little computational cost. The pool should be created only once
and closed when it is no longer needed, to prevent leaks.

Every usage of \code{poolCreate()} should always be paired with a call to
\code{poolClose()} to avoid "leaking" resources. In shiny app, you should
create the pool outside of the server function and close it on stop,
i.e. \code{onStop(function() pool::poolClose(pool))}.

See \code{\link[=dbPool]{dbPool()}} for an example of object pooling applied to DBI database
connections.
}
