% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{time}
\alias{time}
\alias{time<-}
\alias{time,missing-method}
\alias{time,pomp-method}
\alias{time<-,pomp-method}
\title{Methods to extract and manipulate the obseration times}
\usage{
\S4method{time}{pomp}(x, t0 = FALSE, ...)

\S4method{time}{pomp}(object, t0 = FALSE, ...) <- value
}
\arguments{
\item{x}{a \sQuote{pomp} object}

\item{t0}{logical; should the zero time be included?}

\item{\dots}{ignored or passed to the more primitive function}

\item{object}{a \sQuote{pomp} object}

\item{value}{numeric vector; the new vector of times}
}
\description{
Get and set the vector of observation times.
}
\details{
\code{time(object)} returns the vector of observation times.
\code{time(object,t0=TRUE)} returns the vector of observation
times with the zero-time \code{t0} prepended.

\code{time(object) <- value} replaces the observation times slot (\code{times}) of \code{object} with \code{value}.
\code{time(object,t0=TRUE) <- value} has the same effect, but the first element in \code{value} is taken to be the initial time.
The second and subsequent elements of \code{value} are taken to be the observation times.
Those data and states (if they exist) corresponding to the new times are retained.
}
\seealso{
Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond.logLik}()},
\code{\link{covmat}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{timezero}()},
\code{\link{traces}()}
}
\concept{extraction methods}
