% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{vmeasure}
\alias{vmeasure}
\alias{vmeasure,ANY-method}
\alias{vmeasure,missing-method}
\alias{vmeasure,pomp-method}
\title{vmeasure}
\usage{
\S4method{vmeasure}{pomp}(object, x, times, params, ...)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{vmeasure} returns a rank-4 array of dimensions
\code{nobs} x \code{nobs} x \code{nrep} x \code{ntimes},
where \code{nobs} is the number of observed variables.
If \code{v} is the returned array, \code{v[,,j,k]} contains the
covariance matrix at time \code{times[k]} given the state \code{x[,j,k]}.
}
\description{
Return the covariance matrix of the observed variables, given values of the latent states and the parameters.
}
\seealso{
Specification of the measurement-model covariance matrix: \link{vmeasure specification}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{workhorses}}
}
\concept{pomp workhorses}
