library(pomp)

dat <- '"time";"y1";"y2"
1;-1,70081613181228;4,24746468495763
2;0,242170113354698;7,03941580692464
3;3,76758938785925;2,97520908716299
4;5,68588808149477;-1,47040054732921
5;3,77452601600709;-4,43380857201258
6;-3,08021312625511;-3,91887931755601
7;-2,62344860290795;-1,03202457662666
8;-2,86592128836057;4,35432873921529
9;-0,57760946681527;3,39758289565346
10;2,74097620676726;4,91071465265353
11;-0,95441253676346;10,1937011763325
12;-0,991464112428821;6,61823476151473
13;3,84297778313153;7,16145392465002
14;11,0789623105051;4,16444989466932
15;8,59819025333584;-4,90334695500249
16;2,19964347503517;-10,2511439107283
17;-1,13492397511025;-10,3624312929729
18;-2,56413579798821;-8,16885880550387
19;-4,91536849799727;-7,2203116145846
20;-4,33899642531645;-2,31022153289937
21;-1,35937286561288;2,99698279033669
22;-4,0242840268505;3,69116465405162
23;2,9387644957218;6,15414586126603
24;4,31828658150857;5,69290844809883
25;3,53319543208941;3,46054629112961
26;6,44281783433088;-4,79748856413256
27;0,718035321052913;-7,62976005316743
28;1,28027528075623;-6,25270934959545
29;3,70910008919496;-9,94125507650066
30;1,48104366840107;-10,2850854614516
31;-0,209117126395869;-8,80046618352614
32;-5,81639714549404;-13,2283385097361
33;-10,0225182259708;-6,4113389217938
34;-6,89506104214256;-0,998400718547352
35;-6,08611873904796;1,29299352993825
36;-7,74305796307499;5,90263448168222
37;0,0287081408447805;5,88274335246936
38;9,62512958922631;2,54860024892302
39;4,61772012246597;-4,51699357410536
40;-1,40028864684968;-3,66192759013006
41;-6,10811040670547;-4,38003912739696
42;-0,658058036920092;-1,7236046423518
43;-3,49326574531689;-4,14959269754278
44;2,54826871576915;-1,40873093710545
45;-0,640114486048052;0,896862978414845
46;-1,67566665036179;0,379384529694427
47;0,488141779118929;2,07741847310818
48;0,975197260459797;2,83822178936221
49;-1,0207098675894;0,112186038274661
50;0,0342598900248652;3,50605179482128
51;-2,39842556182189;2,92854885312383
52;5,19015239107048;-0,0089221935515531
53;4,14310779510487;0,268899079252409
54;2,63260618646816;1,60371893328454
55;-1,55607266713321;-0,764379706108408
56;-0,545766983243217;-0,837246196106889
57;1,34912551213756;-4,15285169037281
58;0,970330264719094;0,379978231358855
59;-5,04652345030695;-0,444477177942712
60;-3,97209430320528;1,10490455647656
61;-3,20325965055922;5,69632695844117
62;1,03436272221434;7,86129746544832
63;0,667898750837872;10,4068175981576
64;3,50430639591665;9,2816749036714
65;0,925079731276049;5,05429708955105
66;1,46558192088153;0,403851869094214
67;2,69317536547979;-4,51756265008713
68;-2,41608073604264;-8,3370959564069
69;-4,53015031919341;-3,20513929382432
70;-11,0133845324347;-1,33315487824171
71;-10,7508370993112;5,17621264446314
72;-10,5218612264298;8,61966772995883
73;-8,57143649619155;11,4982952428018
74;-3,99562214384817;12,5937325399812
75;-2,71455145450133;15,5796601067951
76;0,512617531996642;16,8599826830534
77;8,77766626349685;11,8289064956647
78;9,92868196527894;5,40891154021026
79;4,66011726941136;1,15575075091348
80;2,67821752937628;-0,585565498904033
81;1,15068730079675;-5,26069159041533
82;-2,203829735812;-7,73574749590483
83;-1,36113119160702;-6,51696428184672
84;-4,49088592785424;-6,88875950760792
85;-6,95435086585582;-5,73210381080353
86;-7,54286719246903;-2,04743677554387
87;-7,25975156626116;-1,10509448997233
88;-5,31555444374504;2,94363686064014
89;1,9728018375925;4,08030586218171
90;2,87436582964618;1,2087743319357
91;2,96600944673318;1,85680168956727
92;4,63179378892858;3,07085679112279
93;5,62360583343836;-2,89483235988436
94;1,87661311794902;-3,00789937429844
95;-0,0144619140532691;-2,67204400181558
96;1,94214418106964;-6,14711561527305
97;1,98468512734267;-5,61898548532659
98;-1,41012196458721;-11,086585198673
99;-7,29715227580992;-4,07855448780968
100;-4,81538906352058;-1,00365875150418
'

pomp(
  data=read.csv2(text=dat),
  times="time",
  t0=0,
  rprocess=discrete.time.sim("_ou2_step"),
  dprocess="_ou2_pdf",
  dmeasure = "_ou2_dmeasure",
  rmeasure = "_ou2_rmeasure",
  skeleton = map("_ou2_skel",delta.t=1),
  PACKAGE="pomp",
  paramnames = c(
    "alpha.1","alpha.2","alpha.3","alpha.4",
    "sigma.1","sigma.2","sigma.3",
    "tau"
  ),
  statenames = c("x1","x2"),
  params=c(
    alpha.1=0.8, alpha.2=-0.5, alpha.3=0.3, alpha.4=0.9,
    sigma.1=3, sigma.2=-0.5, sigma.3=2,
    tau=1,
    x1.0=-3, x2.0=4
  )
) -> ou2

c("ou2")
