% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{gp_overview}
\alias{gp_overview}
\title{gp_overview}
\usage{
gp_overview(probgeno_df, cutoff = 0.7, alpha = 0.1)
}
\arguments{
\item{probgeno_df}{A data frame as read from the scores file produced by function
\code{saveMarkerModels} of R package \code{fitPoly}, or equivalently, a data frame containing the following columns:
\describe{
\item{SampleName}{
Name of the sample (individual)
}
\item{MarkerName}{
Name of the marker
}
\item{P0}{
Probabilities of dosage score '0'
}
\item{P1...}{
Probabilities of dosage score '1' etc. (up to max dosage, e.g. P4 for tetraploid population)
}
\item{maxP}{
Maximum genotype probability identified for a particular individual and marker combination
}
\item{maxgeno}{
Most probable dosage for a particular individual and marker combination
}
\item{geno}{
Most probable dosage for a particular individual and marker combination, if \code{maxP} exceeds a user-defined threshold (e.g. 0.9), otherwise \code{NA}
}
}}

\item{cutoff}{a filtering threshold, by default 0.7, to identify individuals with more than \code{alpha} 
non-missing (maximum) genotype probabilities falling below this cut-off. In other words, by using this
default settings (\code{cutoff} = 0.7 and \code{alpha} = 0.1), you require that 90% of markers for an individual were assigned a probability of more than 0.7
in one of the possible genotype dosage classes. This can help identify problematic individuals with many examples of 
diffuse genotype calls. Lowering the threshold allows more diffuse calls to be accepted.}

\item{alpha}{Option to specify the quantile of an individuals' scores that will be used to test against \code{cutoff}, by default 0.1.}
}
\value{
a list with the following elements:
\describe{
\item{probgeno_df}{
Input data, filtered based on chosen \code{cutoff}
}
\item{population_overview}{
data.frame containing summary statistics of each individual's genotyping scores
}
}
}
\description{
Function to generate an overview of genotype probabilities across a population
}
\examples{
\dontrun{
data("gp_df")
gp_overview(gp_df)
}
}
