% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{merge_homologues}
\alias{merge_homologues}
\title{Merge homologues}
\usage{
merge_homologues(LG_hom_stack, ploidy, LG, mergeList = NULL,
  log = NULL)
}
\arguments{
\item{LG_hom_stack}{A \code{data.frame} with markernames, linkage group (\code{"LG"}) and homologue (\code{"homologue"})}

\item{ploidy}{The ploidy level of the plant species.}

\item{LG}{The linkage group where the to be merged homologue fragments are in.}

\item{mergeList}{A list of vectors of length 2, specifying the numbers of the homologue fragments to be merged. User input is asked if \code{NULL}.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
A modified LG_hom_stack
}
\description{
Based on additional information, homologue fragments, separated during clustered should be merged again.
\code{merge_homologues} allows to merge homologues per linkage group based on user input.
}
\examples{
data("LGHomDf_P2_1")
merged<-merge_homologues(LGHomDf_P2_1,ploidy=4,LG=2,mergeList=list(c(1,5)))
}
