% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aiding_functions.R
\name{calcPotShifts}
\alias{calcPotShifts}
\title{Calculate potential shifts in marker dosages}
\usage{
calcPotShifts(segtypes, ploidy)
}
\arguments{
\item{segtypes}{Vector of segregation types}

\item{ploidy}{The ploidy of the species}
}
\value{
Data.frame with columns:
\item{segtype}{ The segtype code before the underscore i.e. without the first dosage class
}
\item{mindos}{ The first dosage class
}
\item{shift}{ -1, 0 or 1: potental shifts to try out for each segtype whether a shift of +/- 1 
should be tried or not (0) (only when number of dosages in segtype in <= ploidy-2 and 
min.dosage==1 or max.dosage==ploidy-1)
}
}
\description{
Internal function for \code{correctDosages} function
}
