% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{restore}
\alias{restore}
\title{Restore S4 object with data.table slots}
\usage{
restore(filename)
}
\arguments{
\item{filename}{A *.rds file to restore.}
}
\description{
Reloading an S4 object that has a slot with a \code{data.table} may result in
buggy behavior. this auxiliary function will copy the \code{data.table} once
to have a restored object that works.
}
\examples{
k <- kwic("REUTERS", query = "oil")
kwicfile <- tempfile()
saveRDS(k, file = kwicfile)
k <- restore(filename = kwicfile)
k2 <- enrich(k, s_attribute = "id")
}
