% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooccurrences_method.R
\docType{methods}
\name{cooccurrences}
\alias{cooccurrences}
\alias{cooccurrences,character-method}
\alias{cooccurrences,context-method}
\alias{cooccurrences,partition-method}
\title{Get cooccurrence statistics.}
\usage{
cooccurrences(.Object, ...)

\S4method{cooccurrences}{character}(.Object, query = NULL, cqp = is.cqp,
  pAttribute = getOption("polmineR.pAttribute"), sAttribute = NULL,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  stoplist = NULL, positivelist = NULL, keep = NULL, cpos = NULL,
  method = "ll", mc = getOption("polmineR.mc"), verbose = TRUE,
  progress = FALSE)

\S4method{cooccurrences}{partition}(.Object, query, cqp = is.cqp,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  pAttribute = getOption("polmineR.pAttribute"), sAttribute = NULL,
  stoplist = NULL, positivelist = NULL, keep = NULL, method = "ll",
  mc = FALSE, progress = TRUE, verbose = TRUE, ...)

\S4method{cooccurrences}{context}(.Object, method = "ll", verbose = TRUE)
}
\arguments{
\item{.Object}{a partition object, or a character vector with a CWB corpus}

\item{...}{further parameters that will be passed into bigmatrix (applies only of big=TRUE)}

\item{query}{query, may by a character vector to match a token, or a CQP query}

\item{cqp}{defaults to \code{is.cqp}-function, or provide TRUE/FALSE, relevant only if query is not NULL}

\item{pAttribute}{the pAttribute of the tokens/the query}

\item{sAttribute}{if provided, it will be checked that cpos do not extend beyond
the region defined by the s-attribute}

\item{left}{no of tokens and to the left of the node word}

\item{right}{no of tokens to the right of the node word}

\item{stoplist}{exclude a query hit from analysis if stopword(s) is/are in
context (relevant only if query is nut NULL)}

\item{positivelist}{character vector or numeric vector: include a query hit
only if token in positivelist is present. If positivelist is a character
vector, it is assumed to provide regex expressions (incredibly long if the
list is long) (relevant only if query is nut NULL)}

\item{keep}{list with tokens to keep}

\item{cpos}{integer vector with corpus positions, defaults to NULL - then the corpus positions for the whole corpus will be used}

\item{method}{statistical test to use (defaults to "ll")}

\item{mc}{whether to use multicore}

\item{verbose}{logical, whether to be verbose}

\item{progress}{logical, whether to be verbose}
}
\value{
a cooccurrences-class object
}
\description{
Get cooccurrence statistics.
}
\examples{
\dontrun{
use("polmineR.sampleCorpus")
merkel <- partition("PLPRBTTXT", text_type = "speech", text_name = ".*Merkel", regex = TRUE)
merkel <- enrich(merkel, pAttribute = "word")
cooc <- cooccurrences(merkel, query = "Deutschland")
}
}
\author{
Andreas Blaette
}

