#' CPS - School Profile Information, SY 2018-2019
#'
#' School profile information for all schools in the Chicago Public School (CPS)
#' district for the school year (SY) 2018-2019.
#'
#' @format A data frame of 660 observations - one record per school - and 81 variables
#' @source City of Chicago Data Portal \url{https://data.cityofchicago.org/Education/Chicago-Public-Schools-School-Profile-Information-/kh4r-387c}
#' @name cps_sy1819
NULL


#'
#' A SpatialPolygonsDataFrame of the city boundary of Chicago
#'
#' A SpatialPolygonsDataFrame of the city boundary of Chicago
#' that can only be used with the sp and rgdal packages.
#'
#' @format A SpatialPolygonsDataFrame with 1 observation and 4 variables
#' @source City of Chicago Data Portal \url{https://data.cityofchicago.org/Facilities-Geographic-Boundaries/Boundaries-City/ewy2-6yfk}
#' @name city_boundary_spdf
NULL


#' A simple feature containing the city boundary of Chicago.
#'
#' A simple feature containing the city boundary of Chicago
#' that can only be used with the sf package
#'
#' @format A simple feature with 1 observation and 5 variables
#' @source City of Chicago Data Portal \url{https://data.cityofchicago.org/Facilities-Geographic-Boundaries/Boundaries-City/ewy2-6yfk}
#' @name city_boundary_sf
NULL


#' A SpatialPolygonsDataFrame of Chicago's 77 community areas
#'
#' 77 community area boundaries in Chicago that only be used with
#' the sp and rgdal packages
#'
#' @format A SpatialPolygonsDataFrame with 77 observations and 2 variables
#' @source City of Chicago Data Portal \url{https://data.cityofchicago.org/Facilities-Geographic-Boundaries/Boundaries-Community-Areas-current-/cauq-8yn6}
#' @name community_areas_spdf
NULL


#'
#' A simple feature of Chicago's 77 community areas
#'
#' 77 community area boundaries in Chicago that only be used with
#' the sf package
#'
#' @format A simple feature with 77 observations and 3 variables
#' @source City of Chicago Data Portal \url{https://data.cityofchicago.org/Facilities-Geographic-Boundaries/Boundaries-Community-Areas-current-/cauq-8yn6}
#' @name community_areas_sf
NULL

