% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_ops.R
\name{set_read_fn}
\alias{set_read_fn}
\title{Set a table-reading function to an \emph{agent} or \emph{informant}}
\usage{
set_read_fn(x, read_fn)
}
\arguments{
\item{x}{An \emph{agent} object of class \code{ptblank_agent}, or, an \emph{informant} of
class \code{ptblank_informant}.}

\item{read_fn}{A function that's used for reading in the data. This can be
specified by using a function (e.g., \verb{function() \{ <table reading code> \}})
or an R formula expression (e.g., \verb{~ \{ <table reading code> \}}).}
}
\description{
A table-reading function can be associated with an \emph{agent} or \emph{informant}
with \code{set_read_fn()}. Should both a \code{tbl} \emph{and} a \code{read_fn} be associated
with the \emph{agent} or \emph{informant}, the \code{read_fn} will take priority. There are
two ways to specify a \code{read_fn}: (1) using a function (e.g.,
\verb{function() \{ <table reading code> \}}) or, (2) with an R formula expression
(e.g., \verb{~ \{ <table reading code> \}}). The table-reading function can removed
with \code{\link[=remove_read_fn]{remove_read_fn()}}.
}
\section{Function ID}{

8-5
}

\seealso{
Other Object Ops: 
\code{\link{remove_read_fn}()},
\code{\link{remove_tbl}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
