% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_ops.R
\name{remove_read_fn}
\alias{remove_read_fn}
\title{Remove a table-reading function associated with an \emph{agent} or \emph{informant}}
\usage{
remove_read_fn(x)
}
\arguments{
\item{x}{An \emph{agent} object of class \code{ptblank_agent}, or, an \emph{informant} of
class \code{ptblank_informant}.}
}
\description{
Removing an \emph{agent} or an \emph{informant}'s association to a table-reading
function can be done with \code{remove_read_fn()}. This may be good idea in an
interactive session when instead relying on the direct association of a data
table (settable in \code{\link[=create_agent]{create_agent()}} and \code{\link[=create_informant]{create_informant()}}'s \code{tbl} argument
or with \code{\link[=set_tbl]{set_tbl()}}). The table-reading function can be set again with
\code{\link[=set_read_fn]{set_read_fn()}}.
}
\section{Function ID}{

8-6
}

\seealso{
Other Object Ops: 
\code{\link{remove_tbl}()},
\code{\link{set_read_fn}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
