% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_informant.R
\name{yaml_informant_incorporate}
\alias{yaml_informant_incorporate}
\title{Get an \emph{informant} from \strong{pointblank} YAML and \code{incorporate()}}
\usage{
yaml_informant_incorporate(filename, path = NULL)
}
\arguments{
\item{filename}{The name of the YAML file that contains fields related to an
\emph{informant}.}

\item{path}{An optional path to the YAML file (combined with \code{filename}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
The \code{yaml_informant_incorporate()} function operates much like the
\code{\link[=yaml_read_informant]{yaml_read_informant()}} function (reading a \strong{pointblank} YAML file and
generating an \emph{informant} with all information in place). The key difference
is that this function takes things a step further and incorporates aspects
from the the target table (defined by table-prep formula that is required in
the YAML file). The additional auto-invocation of \code{\link[=incorporate]{incorporate()}} uses the
default options of that function. As with \code{\link[=yaml_read_informant]{yaml_read_informant()}} the
informant is returned except, this time, it has been updated with the latest
information from the target table.
}
\section{Function ID}{

11-7
}

\examples{
if (interactive()) {

# Let's go through the process of
# developing an informant with information
# about the `small_table` dataset and then
# move all that to a pointblank YAML
# file; this will later be read in as a
# new informant and the target data will
# be incorporated into the info text
# (in one step) with
# `yaml_informant_incorporate()`

# Now create a pointblank `informant`
# object; the data will be referenced
# to `tbl` with a table-prep formula
# (a requirement for writing to YAML)
informant <- 
  create_informant(
    tbl = ~ small_table,
    label = "A simple example with the `small_table`."
  )

# Then, as with any `informant` object, we
# can add information by using as many
# `info_*()` functions as we want
informant <-
  informant \%>\%
  info_columns(
   columns = vars(a),
   info = "In the range of 1 to 10. (SIMPLE)"
  ) \%>\%
  info_columns(
    columns = starts_with("date"),
    info = "Time-based values (e.g., `Sys.time()`)."
  ) \%>\%
  info_columns(
    columns = "date",
    info = "The date part of `date_time`. (CALC)"
  ) \%>\%
  info_section(
    section_name = "rows",
    row_count = "There are {row_count} rows available."
  ) \%>\%
  info_snippet(
    snippet_name = "row_count",
    fn = ~ . \%>\% nrow()
  ) \%>\%
  incorporate()

# The informant can be written to a pointblank
# YAML file with `yaml_write()`
yaml_write(
  informant = informant,
  filename = "informant-small_table.yml"
)

# The 'informant-small_table.yml' file
# is available in the package through
# `system.file()`
yml_file <- 
  system.file(
    "yaml", "informant-small_table.yml",
    package = "pointblank"
  )

# We can incorporate the data (which
# is accessible through the table-prep
# formula) into the info text through
# direct use of the YAML file with
# `yaml_informant_incorporate()`
informant <- 
  yaml_informant_incorporate(filename = yml_file)

class(informant)

# If it's desired to only create a new
# informant with the information in place
# (stopping short of processing), then the
# `yaml_read_informant()` function will
# be useful
informant <- 
  yaml_read_informant(filename = yml_file)

class(informant)

}

}
\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
