% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_remove_address_prefix}
\alias{utils_remove_address_prefix}
\title{Clear undesired address prefixes}
\usage{
utils_remove_address_prefix(directory, regex, ignore_case)
}
\arguments{
\item{directory}{A directory dataframe with an \code{addresses} column.}

\item{regex}{Regex character string to be use for matching.}

\item{ignore_case}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) in search for \code{regex} in \code{addresses} column
entries of \code{directory}.}
}
\value{
A dataframe.
}
\description{
Clear address entries in the provided directory dataframe of undesired
prefixes such as "depot", "office", "store", "works" or "workshops".
}
\examples{
\dontrun{
  directory <- data.frame(
    page = c("71", "71"),
    surname = c("ABOT", "ABRCROMBIE"), forename = c("Wm.", "Alex"),
    occupation = c("Wine and spirit merchant", "Baker"),
    addresses = c(
      "depot -; 1820 London    st. ; house, Mary hill.*",
      "workshop,,12 &;Dixon st.; residence,    Craigrownie, Cove.$   "
    ),
    stringsAsFactors = FALSE
  )
  regex <- globals_regex_address_prefix
  utils_remove_address_prefix(directory, regex, TRUE)
}
}
