% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-select.R
\name{step.M}
\alias{step.M}
\title{Mathur's AutoDX-like automatic step selection}
\usage{
step.M(
  FUN,
  x,
  h0 = NULL,
  max.rel.error = .Machine$double.eps^(7/8),
  range = NULL,
  shrink.factor = 0.5,
  min.valid.slopes = 5L,
  seq.tol = 0.01,
  correction = TRUE,
  plot = FALSE,
  cores = 1,
  preschedule = getOption("pnd.preschedule", TRUE),
  cl = NULL,
  ...
)
}
\arguments{
\item{FUN}{Function for which the optimal numerical derivative step size is needed.}

\item{x}{Numeric scalar: the point at which the derivative is computed and the optimal step size is estimated.}

\item{h0}{Numeric scalar: initial step size, defaulting to a relative step of
slightly greater than .Machine$double.eps^(1/3) (or absolute step if \code{x == 0}).}

\item{max.rel.error}{Error bound for the relative function-evaluation error
(\eqn{\frac{\hat f(\hat x) - f(x)}{f(x)}}{(^f(^x) - f(x))/f(x)}). Measures how noisy a function is.
If the function is relying on numerical optimisation routines, consider setting to
\code{sqrt(.Machine$double.eps)}.
If the function has full precision to the last bit, set to \code{.Machine$double.eps/2}.}

\item{range}{Numeric vector of length 2 defining the valid search range for the step size.}

\item{shrink.factor}{A scalar less than 1 that is used to create a sequence of
step sizes. The recommended value is 0.5. Change to 0.25 for a faster search. This
number should be a negative power of 2 for the most accurate representation.}

\item{min.valid.slopes}{Positive integer: how many points must form a sequence
with the correct slope with relative difference from 2 less than \code{seq.tol}.
If \code{shrink.factor} is small (< 0.33), consider reducing this to 4.}

\item{seq.tol}{Numeric scalar: maximum relative difference between old and new
step sizes for declaring convergence.}

\item{correction}{Logical: if \code{TRUE}, returns the corrected step size (last
point in the sequence times a less-than-1 number to account for the possible
continuation of the downwards slope of the total error); otherwise, returns
the grid point that is is lowest in the increasing sequence of valid error
estimates.}

\item{plot}{Logical: if \code{TRUE}, plots the estimated truncation and round-off
errors.}

\item{cores}{Integer specifying the number of CPU cores used for parallel computation.
Recommended to be set to the number of physical cores on the machine minus one.}

\item{preschedule}{Logical: if \code{TRUE}, disables pre-scheduling for \code{mclapply()}
or enables load balancing with \code{parLapplyLB()}. Recommended for functions that
take less than 0.1 s per evaluation.}

\item{cl}{An optional user-supplied \code{cluster} object  (created by \code{makeCluster}
or similar functions). If not \code{NULL}, the code uses \code{parLapply()} (if \code{preschedule}
is \code{TRUE}) or \code{parLapplyLB()} on that cluster on Windows, and \code{mclapply}
(fork cluster) on everything else.}

\item{...}{Passed to FUN.}
}
\value{
A list similar to the one returned by \code{optim()}:
\itemize{
\item \code{par} – the optimal step size found.
\item \code{value} – the estimated numerical first derivative (using central differences).
\item \code{counts} – the number of iterations (each iteration includes two function evaluations).
\item \code{abs.error} – an estimate of the truncation and rounding errors.
\item \code{exitcode} – an integer code indicating the termination status:
\itemize{
\item \code{0} – Optimal termination due to a sequence of correct reductions.
\item \code{1} – Reductions are slightly outside the tolerance.
\item \code{2} – Tolerances are significantly violated; an approximate minimum is returned.
\item \code{3} – Not enough finite function values; a rule-of-thumb value is returned.
}
\item \code{message} – A summary message of the exit status.
\item \code{iterations} – A list including the step and argument grids,
function values on those grids, estimated derivative values, and estimated error values.
}
}
\description{
Mathur's AutoDX-like automatic step selection
}
\details{
This function computes the optimal step size for central differences using the
\insertCite{mathur2012analytical}{pnd} algorithm.
}
\examples{
f <- function(x) x^4  # The derivative at 1 is 4
step.M(x = 1, f, plot = TRUE)
step.M(x = 1, f, h0 = 1e-9) # Starting low
step.M(x = 1, f, h0 = 1000) # Starting high

f <- sin  # The derivative at pi/4 is sqrt(2)/2
step.M(x = pi/2, f, plot = TRUE)  # Bad case -- TODO a fix
step.M(x = pi/4, f, plot = TRUE)
step.M(x = pi/4, f, h0 = 1e-9) # Starting low
step.M(x = pi/4, f, h0 = 1000) # Starting high
# where the truncation error estimate is invalid
}
\references{
\insertAllCited{}
}
