% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_1cmt.R
\name{calc_ss_1cmt}
\alias{calc_ss_1cmt}
\alias{calc_ss_1cmt_linear_bolus}
\alias{calc_ss_1cmt_linear_infusion}
\alias{calc_ss_1cmt_linear_oral_0}
\alias{calc_ss_1cmt_linear_oral_0_lag}
\alias{calc_ss_1cmt_linear_oral_1_lag}
\alias{calc_ss_1cmt_linear_oral_1}
\title{Calculate C(t) for a 1-compartment linear model at steady-state}
\usage{
calc_ss_1cmt(tad, tau, dose, dur = NULL, tinf = NULL, ...)

calc_ss_1cmt_linear_bolus(tad, tau, dose, ...)

calc_ss_1cmt_linear_infusion(tad, tau, dose, tinf, ...)

calc_ss_1cmt_linear_oral_0(tad, tau, dose, dur, ...)

calc_ss_1cmt_linear_oral_0_lag(tad, tau, dose, dur, ...)

calc_ss_1cmt_linear_oral_1_lag(tad, tau, dose, ...)

calc_ss_1cmt_linear_oral_1(tad, tau, dose, ...)
}
\arguments{
\item{tad}{Time after dose (h)}

\item{tau}{Dosing interval (h)}

\item{dose}{Dose}

\item{dur}{Duration of zero-order absorption (h)}

\item{tinf}{Duration of infusion (h)}

\item{...}{Passed to `calc_derived_1cpt()`}
}
\value{
Concentration of drug at requested time (\code{t}) after a single dose, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 1-compartment linear model at steady-state
}
\section{Functions}{
\itemize{
\item \code{calc_ss_1cmt_linear_bolus}: Calculate C(t) for a 1-compartment linear model with IV bolus dosing at steady state

\item \code{calc_ss_1cmt_linear_infusion}: Calculate C(t) for a 1-compartment linear model with infusion at steady state

\item \code{calc_ss_1cmt_linear_oral_0}: Calculate C(t) for a 1-compartment linear model with zero-order oral absorption at steady state

\item \code{calc_ss_1cmt_linear_oral_0_lag}: Calculate C(t) for a 1-compartment linear model with zero-order oral absorption at steady state, with lag time

\item \code{calc_ss_1cmt_linear_oral_1_lag}: Calculate C(t) for a 1-compartment linear model with first-order oral absorption at steady state, with lag time

\item \code{calc_ss_1cmt_linear_oral_1}: Calculate C(t) for a 1-compartment linear model with first-order oral absorption at steady state
}}

\examples{
Ct <- calc_ss_1cmt_linear_bolus(t=0:24, CL=6, V=25, dose=600, tau=24)
Ct <- calc_ss_1cmt_linear_infusion(tad=0:36, CL=2, V=25, dose=600, tinf=1, tau=24)
Ct <- calc_ss_1cmt_linear_oral_0(tad=0:36, CL=2, V=25, dose=600, dur=1, tau=24)
Ct <- calc_ss_1cmt_linear_oral_0_lag(tad=0:36, CL=2, V=25, dose=600, dur=1, tau=24, tlag=1.5)
Ct <- calc_ss_1cmt_linear_oral_1_lag(tad=0:36, CL=2, V=25, dose=600,
    ka=0.25, tlag=0.75, tau=24)
Ct <- calc_ss_1cmt_linear_oral_1(tad=0:36, CL=2, V=25, dose=600, ka=0.25, tau=24)
}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{http://lixoft.com/wp-content/uploads/2016/03/PKPDlibrary.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
