% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xform_function.R
\name{xform_function}
\alias{xform_function}
\title{Add a function transformation to a xform_wrap object.}
\usage{
xform_function(
  wrap_object,
  orig_field_name,
  new_field_name = "newField",
  new_field_data_type = "numeric",
  expression,
  map_missing_to = NA
)
}
\arguments{
\item{wrap_object}{Output of xform_wrap or another transformation function.}

\item{orig_field_name}{String specifying name(s) of the original data field(s) being used in the transformation.}

\item{new_field_name}{Name of the new field created by the transformation.}

\item{new_field_data_type}{R data type of the new field created by the transformation ("numeric" or "factor").}

\item{expression}{String expression specifying the transformation.}

\item{map_missing_to}{Value to be given to the transformed variable if the value of any input variable is missing.}
}
\value{
R object containing the raw data, the transformed data and data statistics.
The \code{data} data frame will contain a new \code{new_field_name} column, and
\code{field_data} will contain a new \code{new_field_name} row.
}
\description{
Add a function transformation to a xform_wrap object.
}
\details{
Calculate the expression provided
in \code{expression} for every row in the \code{wrap_object$data}
data frame. The \code{expression} argument must represent
a valid R expression, and any functions used in
\code{expression} must be defined in the current
environment.

The name of the new field is optional (a default name is provided), but an error
will be thrown if attempting to create a field with a name that already exists in
the xform_wrap object.

When \code{new_field_data_type = "numeric"}, the \code{DerivedField} attributes
in PMML will be \code{dataType = "double"} and \code{optype = "continuous"}.
When \code{new_field_data_type = "factor"}, these attributes will be
\code{dataType = "string"} and \code{optype = "categorical"}.
}
\examples{
# Load the standard iris dataset:
data(iris)

# Wrap the data:
iris_box <- xform_wrap(iris)

# Perform a transform on the Sepal.Length field:
# the value is squared and then divided by 100
iris_box <- xform_function(iris_box,
  orig_field_name = "Sepal.Length",
  new_field_name = "Sepal.Length.Transformed",
  expression = "(Sepal.Length^2)/100"
)

# Combine two fields to create another new feature:
iris_box <- xform_function(iris_box,
  orig_field_name = "Sepal.Width, Petal.Width",
  new_field_name = "Width.Sum",
  expression = "Sepal.Width + Sepal.Length"
)

# Create linear model using the derived features:
fit <- lm(Petal.Length ~
Sepal.Length.Transformed + Width.Sum, data = iris_box$data)

# Create pmml from the fit:
fit_pmml <- pmml(fit, transform = iris_box)
}
\seealso{
\code{\link{xform_wrap}}
}
