% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_pmartR.R
\name{summary-omicsData}
\alias{summary-omicsData}
\alias{summary.pepData}
\alias{summary.proData}
\alias{summary.lipidData}
\alias{summary.metabData}
\alias{summary.nmrData}
\alias{summary.seqData}
\title{Produce a basic summary of a pmartR omicsData S3 Object}
\usage{
\method{summary}{pepData}(object, ...)

\method{summary}{proData}(object, ...)

\method{summary}{lipidData}(object, ...)

\method{summary}{metabData}(object, ...)

\method{summary}{nmrData}(object, ...)

\method{summary}{seqData}(object, ...)
}
\arguments{
\item{object}{an object of the class 'lipidData', 'metabData', 'pepData',
'proData', nmrData', or 'seqData' usually created by \code{\link{as.lipidData}},
\code{\link{as.metabData}}, \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.nmrData}}, or \code{\link{as.seqData}}, respectively.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a summary table for the pmartR omicsData object. If assigned to a
  variable, the elements of the summary table are saved in a list format.
}
\description{
This function will provide basic summary statistics for omicsData objects
from the pmartR package.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
pep_summary <- summary(pep_object)
iso_summary <- summary(isobaric_object)
pro_summary <- summary(pro_object)
metab_summary <- summary(metab_object)
lipid_summary <- summary(lipid_neg_object)
nmr_summary <- summary(nmr_identified_object)
rnaseq_summary <- summary(rnaseq_object)
\dontshow{\}) # examplesIf}
}
\author{
Lisa Bramer, Kelly Stratton, Thomas Johansen
}
