% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imd_anova.R
\name{p_adjustment_anova}
\alias{p_adjustment_anova}
\title{Adjust p-values for multiple comparisons}
\usage{
p_adjustment_anova(
  p_values,
  diff_mean,
  t_stats,
  sizes,
  pval_adjust_multcomp,
  pval_adjust_fdr
)
}
\arguments{
\item{p_values}{A matrix (or \code{data.frame}) of p-values to be adjusted.}

\item{diff_mean}{A matrix (or \code{data.frame}) of groups means that are to be compared}

\item{t_stats}{A matrix (or \code{data.frame}) of t-test statistics resulting from from standard procedures}

\item{sizes}{A matrix (or \code{data.frame}) of group sizes}

\item{pval_adjust_multcomp}{character vector specifying the type of multiple comparisons adjustment to implement. A NULL value corresponds to no adjustment. Valid options include: holm, bonferroni, dunnett, tukey or none.}

\item{pval_adjust_fdr}{character vector specifying the type of FDR adjustment to implement. A NULL value corresponds to no adjustment. Valid options include: bonferroni, BH, BY, fdr, or none.}
}
\value{
a data frame with the following columns: group means, global G-test statistic and corresponding p-value
}
\description{
Depending upon the \code{pval_adjust} method selected, the supplied p_values are compared against an adjusted \code{pval_thresh} value or the provided
means are used to compute new statistics, p-values are computed and compared against the provided \code{pval_thresh}.  A \code{data.frame} that indicates which
of the tests are significant, 1 if significant or 0 if insignificant.  If \code{means} is also provided and the p-value is signficant then the direction
of the change is indicated by the sign on 1, i.e., means<0 and p_value<pval_thresh will return -1, similarly for means>0.
}
\author{
Bryan Stanfill
}
