% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imd_anova.R
\name{anova_test}
\alias{anova_test}
\title{Tests for a quantiative difference between groups (aka factors, aka main
effects)}
\usage{
anova_test(
  omicsData,
  groupData,
  comparisons,
  pval_adjust_multcomp,
  pval_adjust_fdr,
  pval_thresh,
  covariates,
  model_selection,
  paired,
  equal_var,
  parallel
)
}
\arguments{
\item{omicsData}{A pmartR data object of any class}

\item{groupData}{`data.frame` that assigns sample names to groups}

\item{comparisons}{`data.frame` with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control  If left NULL, then all
pairwise comparisons are executed.}

\item{pval_adjust_multcomp}{character string specifying the type of multiple
comparisons adjustment to implement. The default, "none", corresponds to no
adjustment. Valid options include: "bonferroni", "holm", "tukey", and
"dunnett".}

\item{pval_adjust_fdr}{character string specifying the type of FDR adjustment
to implement. The default, "none", corresponds to no adjustment. Valid
options include: "bonferroni", "BH", "BY", and "fdr".}

\item{pval_thresh}{numeric p-value threshold, below or equal to which
peptides are considered differentially expressed. Defaults to 0.05}

\item{covariates}{A character vector with no more than two variable names
that will be used as covariates in the IMD-ANOVA analysis.}

\item{model_selection}{Character, one of 'full', 'reduced', or 'auto'
indicating the model to be used in the ANOVA analysis. The default 'full' uses all main
effects, covariates, and interactions between main effects. 'reduced' does 
not consider interactions between main effects. 'auto' performs an F-test
to determine if the full model is necessary. If the F-test is significant,
the full model is used, otherwise the reduced model is used.}

\item{paired}{logical; should the data be paired or not? if TRUE then the
`f_data` element of `omicsData` is checked for a "Pair" column, an error is
returned if none is found}

\item{equal_var}{logical; should the variance across groups be assumed equal?}

\item{parallel}{A logical value indicating if the t test should be run in
parallel.}
}
\value{
a list of `data.frame`s
  \tabular{ll}{
  Results  \tab Edata cname,
  Variance Estimate, ANOVA F-Statistic, ANOVA p-value, Group means\cr \tab
  \cr Fold_changes  \tab Estimated fold-changes for each comparison \cr \tab
  \cr Fold_changes_pvalues  \tab P-values corresponding to the fold-changes
  for each comparison \cr \tab \cr Fold_change_flags  \tab Indicator of
  statistical significance (0/+-2 to if adjusted p-value>=pval_thresh or
  p-value<pval_thresh) \cr
  }
}
\description{
This is the ANOVA part of the IMD-ANOVA test proposed in Webb-Robertson et
al. (2010).
}
\details{
The order in which different scenarios are handeled: \enumerate{ \item If the
data are paired, then the pairing is accounted for first then each of the
next steps is carried out on the new variable that is the difference in the
paired individuals.<br> \item If covariates are provided, their effect is
removed before testing for group differences though mathematically covariates
and grouping effects are accounted for simultaneously \item ANOVA is executed
to assess the effect of each main effects, results in a vector of group means
for each biomolecule and variance estimate \item Group comparisons defined by
`comaprison` argument are implemented use parameter vector and variance
estimates in ANOVA step }
}
\references{
Webb-Robertson, Bobbie-Jo M., et al. "Combined statistical
  analyses of peptide intensities and peptide occurrences improves
  identification of significant peptides from MS-based proteomics data."
  Journal of proteome research 9.11 (2010): 5748-5756.
}
\author{
Bryan Stanfill, Daniel Claborne
}
