% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.nmrnormRes}
\alias{plot.nmrnormRes}
\title{Plot nmrnormRes Object}
\usage{
\method{plot}{nmrnormRes}(
  x,
  nmrData = NULL,
  order_by = NULL,
  color_by = NULL,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = 90,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "none",
  point_size = 2,
  bw_theme = TRUE,
  palette = NULL,
  ...
)
}
\arguments{
\item{x}{an object of type nmrnormRes, created by
\code{\link{normalize_nmr}}}

\item{nmrData}{An nmrData object.}

\item{order_by}{A character string specifying a column in f_data by which to
order the samples.}

\item{color_by}{A character string specifying a column in f_data by which to
color the points.}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label}

\item{y_lab}{character string specifying the y-axis label}

\item{x_lab_size}{integer value indicating the font size for the x-axis. The
default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis. The
default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.}

\item{title_lab}{character string specifying the plot title.}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title.}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{point_size}{integer specifying the size of the points. The default is
2.}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white
theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
Creates a scatter plot for an S3 object of type 'nmrnormRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mynmr <- edata_transform(omicsData = nmr_identified_object, data_scale = "log2")
mynmrnorm <- normalize_nmr(
  omicsData = mynmr,
  apply_norm = FALSE,
  metabolite_name = "unkm1.53"
)
plot(mynmrnorm)

mynmrnorm2 <- normalize_nmr(
  omicsData = mynmr,
  apply_norm = FALSE,
  sample_property_cname = "Concentration"
)
plot(mynmrnorm2)
\dontshow{\}) # examplesIf}
}
