% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results_summary.R
\name{summary-pmartR-results}
\alias{summary-pmartR-results}
\alias{summary.normRes}
\alias{summary.SPANSRes}
\alias{summary.dimRes}
\alias{summary.corRes}
\title{Summary of pmartR Analysis Functions}
\usage{
\method{summary}{normRes}(object, ...)

\method{summary}{SPANSRes}(object, ...)

\method{summary}{dimRes}(object, ...)

\method{summary}{corRes}(object, ...)
}
\arguments{
\item{object}{object of class corRes}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a summary table or list for the pmartR results object
}
\description{
Provide basic summaries for results objects from the pmartR package.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true") & requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mypep <- group_designation(omicsData = pep_object, main_effects = "Phenotype")
mypep <- edata_transform(omicsData = mypep, data_scale = "log2")

norm_result <- normalize_global(omicsData = mypep, norm_fn = "median", subset_fn = "all")
summary(norm_result)

\donttest{
spans_results <- spans_procedure(omicsData = mypep)
summary(spans_results)
}

dim_results <- dim_reduction(omicsData = mypep)
summary(dim_results)

cor_results <- cor_result(omicsData = mypep)
summary(cor_results)
\dontshow{\}) # examplesIf}
}
\author{
Lisa Bramer, Kelly Stratton, Thomas Johansen
}
