% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA.R
\name{ga_pls}
\alias{ga_pls}
\title{Genetic algorithm combined with PLS regression (GA-PLS)}
\usage{
ga_pls(y, X, GA.threshold = 10, iters = 5, popSize = 100)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{GA.threshold}{the change for a zero for mutations and initialization (default = 10). (The ratio of non-selected variables for each chromosome.)}

\item{iters}{the number of iterations (default = 5).}

\item{popSize}{the population size (default = 100).}
}
\value{
Returns a vector of variable numbers corresponding to the model 
having lowest prediction error.
}
\description{
A subset search algorithm inspired by biological
evolution theory and natural selection.
}
\details{
1. Building an initial population of variable sets by setting bits for each variable
 randomly, where bit '1' represents selection of corresponding variable while '0' presents
 non-selection. The approximate size of the variable sets must be set in advance.
 
 2. Fitting a PLSR-model to each variable set and computing the performance by, for instance,
 a leave one out cross-validation procedure.
 
 3. A collection of variable sets with higher performance are selected to survive until the
  next "generation".
  
 4. Crossover and mutation: new variable sets are formed 1) by crossover of selected
 variables between the surviving variable sets, and 2) by changing (mutating) the bit
 value for each variable by small probability.
 
 5. The surviving and modified variable sets form the population serving as input to point 2.
}
\examples{
data(gasoline, package = "pls")
# with( gasoline, ga_pls(octane, NIR, GA.threshold = 10) ) # Time-consuming

}
\references{
K. Hasegawa, Y. Miyashita, K. Funatsu, GA strategy for variable selection
 in QSAR studies: GA-based PLS analysis of calcium channel antagonists, Journal of Chemical
 Information and Computer Sciences 37 (1997) 306-310.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
