% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{style}
\alias{style}
\title{Modify trace(s)}
\usage{
style(p, ..., traces = NULL)
}
\arguments{
\item{p}{A plotly visualization.}

\item{...}{Visual properties.}

\item{traces}{numeric vector. Which traces should be modified? By default,
attributes place in \code{...} will be applied to every trace.}
}
\description{
Modify trace(s) of an existing plotly visualization. Useful when used in
conjunction with \code{\link{get_figure}()}.
}
\examples{

p <- qplot(data = mtcars, wt, mpg, geom = c("point", "smooth"))
# keep the hover info for points, but remove it for the line/ribbon
style(p, hoverinfo = "none", traces = c(2, 3))

}
\seealso{
\code{\link{api_download_plot}()}
}
\author{
Carson Sievert
}
