% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individualQC.R
\name{run_check_ancestry}
\alias{run_check_ancestry}
\title{Run PLINK principal component analysis}
\usage{
run_check_ancestry(
  indir,
  prefixMergedDataset,
  qcdir = indir,
  verbose = FALSE,
  path2plink = NULL,
  showPlinkOutput = TRUE
)
}
\arguments{
\item{indir}{[character] /path/to/directory containing the basic PLINK data
files prefixMergedDataset.bim,prefixMergedDataset.fam and
prefixMergedDataset.bed.}

\item{prefixMergedDataset}{[character] Prefix of merged study and
reference data files, i.e. prefixMergedDataset.bed, prefixMergedDataset.bim,
prefixMergedDataset.fam.}

\item{qcdir}{[character] /path/to/directory to save
prefixMergedDataset.eigenvec as returned by plink --pca. User needs writing
permission to qcdir. Per default qcdir=indir.}

\item{verbose}{[logical] If TRUE, progress info is printed to standard out.}

\item{path2plink}{[character] Absolute path to PLINK executable
(\url{https://www.cog-genomics.org/plink/1.9/}) i.e.
plink should be accesible as path2plink -h. The full name of the executable
should be specified: for windows OS, this means path/plink.exe, for unix
platforms this is path/plink. If not provided, assumed that PATH set-up works
and PLINK will be found by \code{\link[sys]{exec}}('plink').}

\item{showPlinkOutput}{[logical] If TRUE, plink log and error messages are
printed to standard out.}
}
\description{
Run plink --pca to calculate the principal components on merged genotypes
of the study and reference dataset.
}
\details{
Both, \code{\link{run_check_ancestry}} and its evaluation by
\code{\link{evaluate_check_ancestry}} can simply be invoked by
\code{\link{check_ancestry}}.
}
\examples{
indir <- system.file("extdata", package="plinkQC")
qcdir <- tempdir()
prefixMergedDataset <- 'data.HapMapIII'
# the following code is not run on package build, as the path2plink on the
# user system is not known.
\dontrun{
run <- run_check_ancestry(indir=indir, qcdir=qcdir, prefixMergedDataset)
}
}
